/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.Allegrex.compiler;

import jpcsp.Allegrex.Common;
import jpcsp.Allegrex.compiler.CodeInstruction;
import jpcsp.Allegrex.compiler.CompilerContext;
import org.objectweb.asm.MethodVisitor;

public class SequenceSWCodeInstruction
extends CodeInstruction {
    protected int baseRegister;
    protected int[] offsets;
    protected int[] registers;

    public SequenceSWCodeInstruction(int baseRegister, int[] offsets, int[] registers) {
        this.baseRegister = baseRegister;
        this.offsets = offsets;
        this.registers = registers;
    }

    @Override
    public void compile(CompilerContext context, MethodVisitor mv) {
        this.startCompile(context, mv);
        this.compileInstruction(context);
        context.endInstruction();
    }

    protected String getInstructionName() {
        return "sw";
    }

    protected void compileInstruction(CompilerContext context) {
        context.compileSWsequence(this.baseRegister, this.offsets, this.registers);
    }

    @Override
    public boolean hasFlags(int flags) {
        return false;
    }

    @Override
    public String disasm(int address, int opcode) {
        int i;
        StringBuilder result = new StringBuilder(String.format("%-10s ", this.getInstructionName()));
        for (i = 0; i < this.registers.length; ++i) {
            if (i > 0) {
                result.append("/");
            }
            result.append(Common.gprNames[this.registers[i]]);
        }
        result.append(", ");
        for (i = 0; i < this.offsets.length; ++i) {
            if (i > 0) {
                result.append("/");
            }
            result.append(this.offsets[i]);
        }
        result.append("(");
        result.append(Common.gprNames[this.baseRegister]);
        result.append(")");
        return result.toString();
    }
}

